////////////////////////////////////////////////////////////////////////////////
//
// © 1999 – 2019 OneSpan North America Inc. All rights reserved.
// All rights reserved. https://www.onespan.com/
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * The {@link OrchestrationError} class is the base class used for asynchronous error management in
 * the Orchestration SDK.
 */

NS_REFINED_FOR_SWIFT
@interface OrchestrationError : NSObject

- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;

/** error code attached to the error (see OrchestrationErrorCodes.h)*/
@property (nonatomic, readonly) NSInteger errorCode;

/** exception attached to the error */
@property (nonatomic, readonly, nullable) NSException *exception;

/** error coming from another SDK */
@property (nonatomic, readonly, nullable) NSError *error;

/**
 * Give the intial Error Code coming from one of our SDK
 * 0 otherwise.
 */
@property (nonatomic, readonly) NSInteger internalErrorCode;

@end

NS_ASSUME_NONNULL_END
